function Posterior=BayesSimpleRegressionUpdate(Prior, y, x, dVar)
%	BAYESREGRESSIONUPDATE - Posterior=BayesSimpleRegressionUpdate(Prior, y, x, dVar)
%	Update a normal coefficient prior in the standard regression model.
%   One dimension; minimal error checking.
%	Returns Posterior.mu & Posterior.cov;
%	Posterior.ret is a return code (0=normal).

[n,m] = size(x);
if m~=1
	error('BayesSimpleRegressionUpdate. x does not have one column.')
end
[ny,my] = size(y);
if ny~=n
	error('BayesSimpleRegressionUpdate. rows(y)~=rows(X)')
end
if dVar<=0
	error(['BayesSimpleRegressionUpdate. dVar=' num2str(dVar)])
end
Posterior.ret = 0;

xpx = sum(x.*x);
if xpx==0
	Posterior.mu = Prior.mu;
	Posterior.cov = Prior.cov;
	Posterior.ret = 1;
	return
end
xpy =sum(x.*y);

if isinf(Prior.cov)
	Posterior.mu = xpy/xpx;
	Posterior.cov = dVar/xpx;
else
	covi = 1/xpx;
	Di = xpx/dVar + 1/Prior.cov;
	D = 1/Di;
	d = xpy/dVar + covi*Prior.mu;
	Posterior.mu = D*d;
	Posterior.cov = D;
end
